// FSMOutputDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include <mmsystem.h>
#include "mbctype.h"

#include "ib.h"
#include "FSMOutputDlg.h"
#include "IBFlowView.h"
#include "XISLOutputFSM.h"
#include "FSMClient.h"
#include "SSMClient.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CXISLRootTag *g_pAppRootTag;
/////////////////////////////////////////////////////////////////////////////
// CFSMOutputDlg _CAO


CFSMOutputDlg::CFSMOutputDlg(CXISLOutputFSM *pTag,CXISLTag *pCurrentTag,CWnd* pParent /*=NULL*/)
	: CDialog(CFSMOutputDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFSMOutputDlg)
	m_nCombAutonomous = -1;
	m_nCombExpression = -1;
	m_nDur = 0;
	m_nCombMotionId = -1;
	m_nCombMotion = -1;
	m_strFSMMsg = _T("");
	m_nEventGlp = -1;
	m_strText = _T("");
	m_bEndSync = TRUE;
	//}}AFX_DATA_INIT

	m_strPhoneme = "";
	m_strSpeakDur = "";
	m_bMaskSeted = FALSE;

	m_pOutputTag = pTag;
	m_pCurrentTag = pCurrentTag;
	m_pTextList = NULL;
	m_pFSMClient = NULL;
	m_pSSMClient = NULL;
}


void CFSMOutputDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFSMOutputDlg)
	DDX_Control(pDX, IDC_EDIT_FSMMES, m_editFSMMsg);
	DDX_Control(pDX, IDC_EDIT_SPEAK, m_editText);
	DDX_Control(pDX, IDC_LIST_VAR, m_lbVar);
	DDX_Control(pDX, IDC_COMBO_MASK, m_ComboMask);
	DDX_CBIndex(pDX, IDC_COMBO_AUTONOMOUS, m_nCombAutonomous);
	DDX_CBIndex(pDX, IDC_COMBO_EXPRESSION, m_nCombExpression);
	DDX_Text(pDX, IDC_EDIT_DUR, m_nDur);
	DDV_MinMaxInt(pDX, m_nDur, 0, 99999);
	DDX_CBIndex(pDX, IDC_COMBO_ID, m_nCombMotionId);
	DDX_CBIndex(pDX, IDC_COMBO_MOTION, m_nCombMotion);
	DDX_Text(pDX, IDC_EDIT_FSMMES, m_strFSMMsg);
	DDX_Radio(pDX, IDC_RADIO_MASK, m_nEventGlp);
	DDX_Text(pDX, IDC_EDIT_SPEAK, m_strText);
	DDX_Check(pDX, IDC_CHECK_ENDSYNC, m_bEndSync);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFSMOutputDlg, CDialog)
	//{{AFX_MSG_MAP(CFSMOutputDlg)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_RADIO_MASK, OnRadioMask)
	ON_BN_CLICKED(IDC_RADIO_SPEAK, OnRadioSpeak)
	ON_BN_CLICKED(IDC_RADIO_EXPRESSION, OnRadioExpression)
	ON_BN_CLICKED(IDC_BUTTON_TEST, OnButtonTest)
	ON_BN_CLICKED(IDC_RADIO_AUTONOMOUS, OnRadioAutonomous)
	ON_BN_CLICKED(IDC_RADIO_MOTION, OnRadioMotion)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_VAR, OnDblclkListVar)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


//void CFSMOutputDlg::InitDlgItem()
//@\@FeRg[\
//@F
//ԂlF
void CFSMOutputDlg::InitDlgItem()
{
	GetDlgItem(IDC_COMBO_MASK)->EnableWindow(FALSE);
	GetDlgItem(IDC_COMBO_AUTONOMOUS)->EnableWindow(FALSE);
	GetDlgItem(IDC_COMBO_EXPRESSION)->EnableWindow(FALSE);
	GetDlgItem(IDC_COMBO_MOTION)->EnableWindow(FALSE);
	GetDlgItem(IDC_COMBO_ID)->EnableWindow(FALSE);
	GetDlgItem(IDC_EDIT_SPEAK)->EnableWindow(FALSE);
	GetDlgItem(IDC_EDIT_DUR)->EnableWindow(FALSE);
	GetDlgItem(IDC_CHECK_ENDSYNC)->EnableWindow(FALSE);
}


//void CFSMOutputDlg::SetComboMask(LPCTSTR lpszMaskSet)
//@\@FLN^R{{bNXMASK_IDZbg
//@FLPCTSTR lpszMaskSetFMASK_IDLqꂽ
//ԂlF
void CFSMOutputDlg::SetComboMask(LPCTSTR lpszMaskSet)
{
	CString strMaskSet = lpszMaskSet;
	CString strTemp;

	BOOL bFlag = TRUE;
	int nNext = 0;
	int nIndex = strMaskSet.Find("\"",0) + 1;
	while(bFlag)
	{
		nNext = strMaskSet.Find(",",nIndex+1);
		if(nNext == -1)
		{
			nNext = strMaskSet.GetLength()-1;
			bFlag = FALSE;
		}
		strTemp = strMaskSet.Mid(nIndex,nNext-nIndex);
		m_ComboMask.AddString(strTemp);
		nIndex = nNext + 1;
	}
}


void CFSMOutputDlg::OnSpeakFinished()
{
}

void CFSMOutputDlg::OnSpeakReady(LPCTSTR lpszPhoneme,LPCTSTR lpszDur)
{
	if(m_bProcessing)
	{
		m_strSpeakDur = lpszDur;
		m_pFSMClient->SetLipSync(lpszPhoneme);
		m_bProcessing = false;
	}
}

void CFSMOutputDlg::WriteMsg(LPCTSTR lpszMsg)
{
//	UpdateData();
	m_editFSMMsg.GetWindowText(m_strFSMMsg);
	m_strFSMMsg+=lpszMsg;
	m_editFSMMsg.SetWindowText(m_strFSMMsg);
//	UpdateData(FALSE);

	int nIndex = m_strFSMMsg.GetLength();
	((CEdit*)GetDlgItem(IDC_EDIT_FSMMES))->SetSel(nIndex,nIndex);
}

/////////////////////////////////////////////////////////////////////////////
// CFSMOutputDlg bZ[W nh
BOOL CFSMOutputDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	// TODO: ʂȏs͂̏ꏊɒǉĂB

	//eRg[̏
	InitDlgItem();
	m_lbVar.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);
	LVCOLUMNA column;
	column.mask = LVCF_TEXT|LVCF_WIDTH;

	RECT rect;
	m_lbVar.GetClientRect(&rect);
	column.cx = 70;
	column.pszText = "Scope";
	m_lbVar.InsertColumn(0,&column);

	column.cx = (rect.right-rect.left)-70;
	column.pszText = "ϐ";
	m_lbVar.InsertColumn(1,&column);

	int nType = m_pCurrentTag->m_nTagType;
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pCurrentTag->GetParentExcTag();
	int nCount = pExcItem->m_pLocalVar->SetVar2ListBox(m_lbVar);
		
	CXISLDialogTag *pDTag = (CXISLDialogTag*)pExcItem->GetParentDialogTag();
	nCount = pDTag->m_pDialogVar->SetVar2ListBox(m_lbVar,nCount);
	
	CXISLRootTag *pRTag = (CXISLRootTag*)pDTag->GetRootTag();
	nCount = pRTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
	
	if(!pRTag->IsAppRoot() && g_pAppRootTag)
		g_pAppRootTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);


	SetComboMask("MaskSet = \"yamada,sagayama,saskia,morishima\"");

	CString strParam;
	if(m_pOutputTag->m_nOutputEvent == ID_FSMEVENT_SPEECH)
	{
		m_nEventGlp = 4;
		OnRadioSpeak();
		m_strText = m_pOutputTag->GetText(strParam);
		m_pOutputTag->GetExpression(m_nCombExpression,m_nDur);
		m_nDur = 0;
		UpdateData(FALSE);
	}
	else if(m_pOutputTag->m_nOutputEvent == ID_FSMEVENT_CHARACTER)
	{
		m_nEventGlp = 0;
		OnRadioMask();
		int nIndex = m_ComboMask.FindString(-1,m_pOutputTag->GetCharactor());
		if(nIndex == -1)
			nIndex = 0;
		m_ComboMask.SetCurSel(nIndex);
		UpdateData(FALSE);
	}
	else if(m_pOutputTag->m_nOutputEvent == ID_FSMEVENT_AUTONOMOUS)
	{
		m_nEventGlp = 1;
		OnRadioAutonomous();
		m_nCombAutonomous = m_pOutputTag->GetAutonomous();
		UpdateData(FALSE);
	}
	else if(m_pOutputTag->m_nOutputEvent == ID_FSMEVENT_EXPRESSION)
	{
		m_nEventGlp = 2;
		OnRadioExpression();
		m_pOutputTag->GetExpression(m_nCombExpression,m_nDur);
		UpdateData(FALSE);
	}
	else if(m_pOutputTag->m_nOutputEvent == ID_FSMEVENT_MOTION)
	{
		m_nEventGlp = 3;
		OnRadioMotion();
		m_pOutputTag->GetMotion(m_nCombMotion,m_nCombMotionId);
		m_nCombMotionId--;
		UpdateData(FALSE);
	}
	else
	{
		m_nEventGlp = 0;
		OnRadioMask();
	}

	((CMainFrame*)AfxGetMainWnd())->ConnectIPAEngine(this);
	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

void CFSMOutputDlg::OnDestroy() 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ

	CDialog::OnDestroy();
}


//////// LN^w /////////
void CFSMOutputDlg::OnRadioMask() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
	m_ComboMask.EnableWindow();

	//MaskSeto^ȂFSMɗv
	if(!m_bMaskSeted)
	{
		if(m_pFSMClient)
			m_pFSMClient->SendMsg("inq MaskSet./\n");

		m_bMaskSeted = TRUE;
	}
}

////////  /////////
void CFSMOutputDlg::OnRadioAutonomous() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
	GetDlgItem(IDC_COMBO_AUTONOMOUS)->EnableWindow();
}

//////// b /////////
void CFSMOutputDlg::OnRadioSpeak() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
	GetDlgItem(IDC_EDIT_SPEAK)->EnableWindow();
	GetDlgItem(IDC_COMBO_EXPRESSION)->EnableWindow();
	GetDlgItem(IDC_CHECK_ENDSYNC)->EnableWindow();
}

//////// \ /////////
void CFSMOutputDlg::OnRadioExpression() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
	GetDlgItem(IDC_COMBO_EXPRESSION)->EnableWindow();
	GetDlgItem(IDC_EDIT_DUR)->EnableWindow();
}


//////// 瓮 /////////
void CFSMOutputDlg::OnRadioMotion() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();

	GetDlgItem(IDC_COMBO_MOTION)->EnableWindow();
	GetDlgItem(IDC_COMBO_ID)->EnableWindow();
}

void CFSMOutputDlg::OnButtonTest() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();

	if(m_pFSMClient == NULL || m_pSSMClient == NULL)
	{
		AfxMessageBox("mFsȂɂ͐ɊeGWNKv܂",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		return;
	}

	char chrParam[10];
	CString strParam;
	int nStart=0,nEnd;
	switch(m_nEventGlp)
	{
	case 0:
		m_ComboMask.GetWindowText(strParam);
		if(strParam.IsEmpty())
			return;

		m_pFSMClient->Character(strParam);
		break;
	case 1:
		if(m_nCombAutonomous == -1)
			return;

		m_pFSMClient->Autonomous(FSM_AUTONOMOUS_PARAM[m_nCombAutonomous]);
		break;
	case 2:
		if(m_nCombExpression == -1)
			return;

		m_pFSMClient->FaceExp(FSM_EXPRESSION_PARAM[m_nCombExpression],itoa(m_nDur,chrParam,10));
		break;
	case 3:
		if(m_nCombMotion == -1)
			return;

		m_pFSMClient->FaceMot(FSM_MOTION_PARAM[m_nCombMotion],itoa(m_nCombMotionId+1,chrParam,10));
		break;
	case 4:
		if(m_nCombExpression == -1)
			m_strSpeakExpression = FSM_EXPRESSION_PARAM[ID_FSMEXPRESSION_NEUTRAL];
		else
			m_strSpeakExpression = FSM_EXPRESSION_PARAM[m_nCombExpression];

		while(1)
		{
			nStart = m_strText.Find(" $",nStart);
			if(nStart == -1)
				break;
			nEnd = m_strText.Find(" ",nStart+1);
			if(nEnd == -1)
				nEnd = m_strText.GetLength();
			m_strText.Delete(nStart,nEnd-nStart);
			m_strText.Insert(nStart," ϐ");
		}
		m_pSSMClient->SetText(m_strText,true);
		m_bProcessing = true;
		break;
	}
}

void CFSMOutputDlg::FSMSpeak(BOOL bSpeakReady)
{
	CString strTemp = "";
}

void CFSMOutputDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	UpdateData();

	BOOL bFlag=TRUE;
	CString strParam;
	switch(m_nEventGlp)
	{
	case 0://ID_FSMEVENT_CHARACTER:
		m_ComboMask.GetWindowText(strParam);
		if(strParam.IsEmpty())
			bFlag = FALSE;
		else
			m_pOutputTag->SetCharactor(strParam);
		break;
	case 1://ID_FSMEVENT_AUTONOMOUS:
		if(m_nCombAutonomous == -1)
			bFlag = FALSE;
		else
			m_pOutputTag->SetAutonomous(m_nCombAutonomous);
		break;
	case 2://ID_FSMEVENT_EXPRESSION:
		if(m_nCombExpression == -1)
			bFlag = FALSE;
		else
			m_pOutputTag->SetExpression(m_nCombExpression,m_nDur);
		break;
	case 3://ID_FSMEVENT_MOTION:
		if(m_nCombMotion == -1 || m_nCombMotionId == -1)
			bFlag = FALSE;
		else
			m_pOutputTag->SetMotion(m_nCombMotion,m_nCombMotionId+1);
		break;
	case 4://ID_FSMEVENT_SPEECH:
		if(!CreateTextList())
			return;

		if(m_strText.IsEmpty())
			bFlag = FALSE;
		if(m_nCombExpression == -1)
			m_nCombExpression = ID_FSMEXPRESSION_NEUTRAL;
		if(!m_pOutputTag->SetText(m_pTextList,m_nCombExpression,m_bEndSync))
			return;
		break;
	default:
		bFlag = FALSE;
	}

	if(!bFlag)
	{
		AfxMessageBox("p^w肵Ă",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		return;
	}

	if(m_pFSMClient)
		m_pFSMClient->m_pFSMDlg = NULL;
	if(m_pSSMClient)
		m_pSSMClient->m_pFSMDlg = NULL;
	CDialog::OnOK();
}

void CFSMOutputDlg::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	if(m_pTextList)
	{
		while(!m_pTextList->IsEmpty())
		{
			CXISLVar *pVar = (CXISLVar*)m_pTextList->RemoveHead();
			if(pVar->IsDummy())
				delete pVar;
		}
	}	
	CDialog::OnCancel();
}


void CFSMOutputDlg::OnDblclkListVar(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	_TCHAR szBuff[MAX_PATH];
	LVITEMA item;
	item.mask = LVIF_TEXT|LVIF_PARAM|LVIF_STATE;
	item.iItem = pNMListView->iItem;
	item.iSubItem = 0;
	item.pszText = szBuff;
	item.cchTextMax = sizeof(szBuff);
	item.stateMask = 0xFFFF;
	m_lbVar.GetItem(&item);

	if(item.iItem != -1)
	{
		UpdateData();
		int nStart,nEnd;
		m_editText.GetSel(nStart,nEnd);

		if((nStart != 0) && (nStart != m_strText.GetLength()))
		{
			int nSpace1=0,nSpace2=0;
			while(1)
			{
				nSpace1 = m_strText.Find(" $",nSpace1);
				if(nSpace1 == -1)
					break;
				nSpace2 = m_strText.Find(" ",nSpace1+1);
				if(nSpace2 == -1)
					nSpace2 = m_strText.GetLength();

				if(nStart >= nSpace1 && nStart <= nSpace2)
				{
					nStart = nSpace2;
					break;
				}
				nSpace1 = nSpace2;
			}
		}

		CXISLVar *pVar = (CXISLVar*)item.lParam;
		CString strVarName;
		pVar->GetVarNameEx(strVarName);
		strVarName.Insert(0," $");
		strVarName += " ";
		m_strText.Insert(nStart,strVarName);
		UpdateData(FALSE);
	}		
	*pResult = 0;
}

BOOL CFSMOutputDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if( pMsg->message == WM_KEYDOWN )
	{
		if(pMsg->wParam == VK_RETURN)
			return TRUE;

		CWnd *pWnd = GetFocus();
		if(pWnd->GetDlgCtrlID() == IDC_EDIT_TEXT)
		{
			UpdateData();
			int nStart,nEnd;
			int nSpace1=0,nSpace2=0;
			switch( pMsg->wParam )
			{
			case VK_DELETE:
				m_editText.GetSel(nStart,nEnd);
				while(1)
				{
					nSpace1 = m_strText.Find(" $",nSpace1);
					if(nSpace1 == -1)
						break;
					nSpace2 = m_strText.Find(" ",nSpace1+1);
					if(nStart >= nSpace1 && nStart <= nSpace2)
					{
						m_strText.Delete(nSpace1,nSpace2-nSpace1);
						UpdateData(FALSE);
						break;
					}
					nSpace1 = nSpace2;
				}
				break;
			case VK_SPACE:
				return TRUE;
			case VK_BACK:
				m_editText.GetSel(nStart,nEnd);
				while(1)
				{
					nSpace1 = m_strText.Find(" $",nSpace1);
					if(nSpace1 == -1)
						break;
					nSpace2 = m_strText.Find(" ",nSpace1+1)+1;
					if(nStart >= nSpace1 && nStart <= nSpace2)
					{
						m_strText.Delete(nSpace1,nSpace2-nSpace1);
						UpdateData(FALSE);
						break;
					}
					nSpace1 = nSpace2;
				}
				break;				
			default:
				break;
			}
		}
	}		
	return CDialog::PreTranslateMessage(pMsg);
}

BOOL CFSMOutputDlg::CreateTextList()
{
	UpdateData();

	if(m_pTextList == NULL)
		m_pTextList = new CPtrList;

	m_strText.Replace("@"," ");
	int nStart = 0;
	CXISLVar *pText;
	CString strVarName;
	BOOL bOK = TRUE;
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pCurrentTag->GetParentExcTag();
	while(1)
	{
		if(m_strText.IsEmpty())
			break;
		nStart = m_strText.Find(" $",0);
		
		if(nStart == -1)
		{
			pText = new CXISLVar;
			pText->SetAttribute(m_strText,"",FALSE,TRUE);
			m_pTextList->AddTail(pText);
			break;
		}

		if(nStart != 0)
		{
			pText = new CXISLVar;
			pText->SetAttribute(m_strText.Left(nStart),"",FALSE,TRUE);
			m_pTextList->AddTail(pText);
			m_strText.Delete(0,nStart);
		}
		else
		{
			nStart = m_strText.Find(" ",nStart+1);
			if(nStart == -1)
				strVarName = m_strText;
			else
				strVarName = m_strText.Left(nStart);
			strVarName.Remove('$');
			strVarName.Remove(' ');
			CXISLVar *pVar = pExcItem->m_pLocalVar->FindVarWithParent(strVarName);
			if(pVar == NULL)
			{
				AfxMessageBox("݂Ȃϐw肳܂",MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
				bOK = FALSE;
				break;
			}
			m_strText.Delete(0,nStart+1);
			m_pTextList->AddTail(pVar);
			pVar->ReferCount(TRUE);
		}
	}

	if(!bOK)
	{
		while(!m_pTextList->IsEmpty())
		{
			CXISLVar *pVar = (CXISLVar*)m_pTextList->RemoveHead();
			if(pVar->IsDummy())
				delete pVar;
			else
				pVar->ReferCount(FALSE);
		}
	}

	return bOK;
}

void CFSMOutputDlg::PostNcDestroy() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if(m_pTextList)
		delete m_pTextList;

	if(m_pFSMClient)
		m_pFSMClient->m_pFSMDlg = NULL;
	if(m_pSSMClient)
		m_pSSMClient->m_pFSMDlg = NULL;

	CDialog::PostNcDestroy();
}
